% This program illustrates the use of the following functions included in this folder:
%
% plotIT2, mg, negationIT2,complementIT2,centroidIT2,fuzzinessIT2,cardinalityIT2,
% varianceIT2,skewnessIT2, intersectionIT2, unionIT2
%
% For their definitions, refer to:
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in Making Subjective Judgments, 
% Wiley-IEEE Press, 2010.
%
% Last modifed by Dongrui Wu, dongruiw@usc.edu, July 29, 2009

clc
close all
clear all

% Define the IT2 FS. You can have different numbers of samples for UMF and
% LMF when the functions mg, plotIT2, negationIT2 and complementIT2 are
% used, e.g.:
xUMF=[0 2 4  5 7];
uUMF=[0 1 1 .9 0];
xLMF=[1 3  6];
uLMF=[0 .8  0];

figure
subplot(3,1,1);
plotIT2(xUMF,uUMF,xLMF,uLMF,[0 10]); % plotIT2
x=linspace(0,10,100);
hold on
plot(x,mg(x,xUMF,uUMF),'r--','linewidth',2); % mg, UMF
plot(x,mg(x,xLMF,uLMF),'b:','linewidth',2); % mg, LMF
axis([0 10 0 1.4]);
text('Interpreter','latex','String','$\widetilde{A}$','Position',[mean(xUMF(2:3)),1.2],...
    'fontsize',12,'horizontalalignment','center');

[xUMF2,uUMF2,xLMF2,uLMF2]=complementIT2(xUMF,uUMF,xLMF,uLMF,[0 10]); % complementIT2
subplot(3,1,2);
plotIT2(xUMF2,uUMF2,xLMF2,uLMF2,[0 10]);
axis([0 10 0 1.4]);
text('Interpreter','latex','String','$\widetilde{A}^c$','Position',[mean(xLMF2(2:3)),1.2],...
    'fontsize',12,'horizontalalignment','center');

[xUMF2,uUMF2,xLMF2,uLMF2]=antonymIT2(xUMF,uUMF,xLMF,uLMF,10); % antonymIT2
subplot(3,1,3);
plotIT2(xUMF2,uUMF2,xLMF2,uLMF2,[0 10]);
axis([0 10 0 1.4]);
text('Interpreter','latex','String','$10-\widetilde{A}$','Position',[mean(xUMF2(2:3)),1.2],...
    'fontsize',12,'horizontalalignment','center');

A=[0 2 4 7 1 3 3 6 0.8];
centroid=centroidIT2(A)
fuzziness=fuzzinessIT2(A)
cardinality=cardinalityIT2(A)
variance=varianceIT2(A)
skewness=skewnessIT2(A)

B=[3 5 7 9 4 6 7 8 0.6];
figure
subplot(3,1,1);
plotIT2(A);
hold on
plotIT2(B,[0 10]);
axis([0 10 0 1.4]);
text('Interpreter','latex','String','$\widetilde{A}$','Position',[mean(A(2:3)),1.2],...
    'fontsize',12,'horizontalalignment','center');
text('Interpreter','latex','String','$\widetilde{B}$','Position',[mean(B(2:3)),1.2],...
    'fontsize',12,'horizontalalignment','center');

[xUMF2,uUMF2,xLMF2,uLMF2]=intersectionIT2(A,B);
subplot(3,1,2);
plotIT2(xUMF2,uUMF2,xLMF2,uLMF2);
axis([0 10 0 1.4]);
text('Interpreter','latex','String','$\widetilde{A}\cap\widetilde{B}$','Position',[4.6,1.2],...
    'fontsize',12,'horizontalalignment','center');

[xUMF2,uUMF2,xLMF2,uLMF2]=unionIT2(A,B);
subplot(3,1,3);
plotIT2(xUMF2,uUMF2,xLMF2,uLMF2);
axis([0 10 0 1.4]);
text('Interpreter','latex','String','$\widetilde{A}\cup\widetilde{B}$','Position',[4.6,1.2],...
    'fontsize',12,'horizontalalignment','center');


